% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Caswell.R
\name{ltre}
\alias{ltre}
\title{Caswell's LTRE method of decomposition}
\usage{
ltre(func, pars1, pars2, dfunc, N = 20, ...)
}
\arguments{
\item{func}{A function specified by the user. This must be able to take the vectors \code{rates1} or 
\code{rates2} as its argument, and to return the value of the function, \code{y}, when evaluated for 
these rates. It may also have additional arguments, not to be decomposed.}

\item{pars1}{vector of covariates to be passed on as arguments to \code{func()}. Covariates
can be in any order, as long as \code{func()} knows what to do with them. \code{pars1} is for time 1 
(or population 1).}

\item{pars2}{is the same as \code{pars2} but for time/population 2.}

\item{dfunc}{a derivative function, see details}

\item{N}{The number of intervals to integrate over.}

\item{...}{\dots optional parameters to pass on to \code{func()}. These are not decomposed. Also one can use this argument to pass optional arguments to \code{numDeriv::grad()}.}
}
\description{
Caswell's Lifetable Response Experiment (LTRE) decomposed a vector-parameterized 
function by taking derivatives of the objective function with respect to each parameter. The 
sum-product of the resulting derivative vector and the change in parameter values is a first order
approximation of the decomposition. This implementation repeats this operation \code{N} times as 
\code{pars1} warps into \code{pars2} over \code{N} steps. This allows for arbitrary precision as 
\code{N} increases, as in the case of the Horiuchi approach.
}
\details{
The case of \code{N=1} differentiates with respect to the arithmetic mean of \code{pars1} and \code{pars2}. The \code{...} argument can be used to send extra parameters to \code{func()} that do not get decomposed, or to specify other optional arguments to \code{numDeriv::grad()} for finer control. 

The argument \code{dfunc} is optional. If given, it should be a function written to have a first argument \code{func}, a second argument \code{x}, which consists in the vector of decomposed parameters (same layout at \code{pars1} and \code{pars2}), and an option \code{...} argument for undecomposed parameters. Presumably if a derivative function is given then it is analytic or somehow a more parsimonious calculation than numeric derivatives. If left unspecified \code{numDeriv::grad()} is used.

As with \code{horiuchi()}, the path from \code{pars1} to \code{pars2} is linear, but other paths can be induced by parameterizing \code{func()} differently. For example, if you want proportional change from \code{pars1} to \code{pars2} then log them, and write \code{func()} to first antilog before continuing. This is not zero-friendly, but in practice power transforms give close results, so you could \code{sqrt()} and then square inside \code{func()}. If you do this, then \code{dfunc()} must be written to account for it too, or you could stick with the default numeric gradient function.
}
\references{
\insertRef{caswell1989analysis}{DemoDecomp}
\insertRef{caswell2006matrix}{DemoDecomp}
}
\seealso{
\code{\link[numDeriv]{grad}}
}
