% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{rollapply.DTSg}
\alias{rollapply.DTSg}
\alias{rollapply}
\title{Rolling window function}
\usage{
\method{rollapply}{DTSg}(
  x,
  fun,
  ...,
  cols = self$cols(class = "numeric")[1L],
  before = 1L,
  after = before,
  weights = "inverseDistance",
  parameters = list(power = 1),
  resultCols = NULL,
  suffix = NULL,
  helpers = TRUE,
  memoryOverCPU = TRUE,
  clone = getOption("DTSgClone")
)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{fun}{A \code{\link{function}}. Its return value must be of length one.}

\item{...}{Further arguments passed on to \code{fun}.}

\item{cols}{A character vector specifying the columns whose rolling window
\code{fun} shall be applied to. Another possibility is a character string
containing either comma separated column names, for example, \code{"x,y,z"}, or
the start and end column separated by a colon, for example, \code{"x:z"}.}

\item{before}{An integerish value specifying the size of the window in time
steps before the \dQuote{center} of the rolling window.}

\item{after}{An integerish value specifying the size of the window in time
steps after the \dQuote{center} of the rolling window.}

\item{weights}{A character string specifying the method applied to calculate
the weights handed over to \code{fun}. These are useful for functions like
\code{\link{weighted.mean}}. See corresponding section for further information.}

\item{parameters}{A \code{\link{list}} specifying parameters for the weight calculation
method. See corresponding section for further information.}

\item{resultCols}{An optional character vector of the same length as \code{cols}
specifying the column names for the return values of \code{fun}. Another
possibility is a character string containing comma separated column names,
for example, \code{"x,y,z"}. Non-existing columns are added and existing columns
are overwritten. Columns are matched element-wise between \code{cols} and
\code{resultCols}.}

\item{suffix}{An optional character string. The return values of \code{fun} are
added as new columns with names consisting of the columns specified in
\code{cols} and this suffix. Existing columns are never overwritten. Only used
when \code{resultCols} is not specified.}

\item{helpers}{A logical specifying if helper data shall be handed over to
\code{fun}. See corresponding section for further information.}

\item{memoryOverCPU}{A logical specifying if memory usage shall be preferred
over CPU usage for this method call. The former is generally faster for
smaller windows and shorter time series, the latter for bigger windows and
longer time series or might even be the only one which works depending on
the available hardware.}

\item{clone}{A logical specifying if the object shall be modified in place or
if a deep clone (copy) shall be made beforehand.}
}
\value{
Returns a \code{\link{DTSg}} object.
}
\description{
Applies an arbitrary function to a rolling window of selected columns of a
\code{\link{DTSg}} object with recognised periodicity.
}
\section{Weights}{

Currently, only one method to calculate weights is supported:
\code{"inverseDistance"}. The distance \eqn{d} of the \dQuote{center} is one and
each time step further away from the \dQuote{center} adds one to it. So, for
example, the distance of a timestamp three steps away from the
\dQuote{center} is four. Additionally, the calculation of the weights accepts
a power parameter \eqn{p} as a named element of a \code{\link{list}} provided through
the \code{parameters} argument: \eqn{\frac{1}{d^p}}{1 / d^p}.
}

\section{Helper data}{

In addition to the \code{...} argument, this method optionally hands over the
weights as a numeric vector (\code{w} argument) and a \code{\link{list}} argument with
helper data called \code{.helpers} to \code{fun}. This \code{\link{list}} contains the following
elements:
\itemize{
\item \emph{before:} Same as the \code{before} argument.
\item \emph{after:} Same as the \code{after} argument.
\item \emph{windowSize:} Size of the rolling window (\code{before + 1L + after}).
\item \emph{centerIndex:} Index of the \dQuote{center} of the rolling window
(\code{before + 1L}).
}
}

\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# calculate a moving average
## R6 method
x$rollapply(
  fun = mean,
  na.rm = TRUE,
  before = 2,
  after = 2
)$print()

## S3 method
print(rollapply(
  x = x,
  fun = mean,
  na.rm = TRUE,
  before = 2,
  after = 2
))

}
\seealso{
\code{\link{cols}}, \code{\link{getOption}}
}
