% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatFunctions.R
\name{quantileDP}
\alias{quantileDP}
\title{Differentially Private Quantile}
\usage{
quantileDP(
  x,
  quant,
  eps,
  lower.bound,
  upper.bound,
  which.sensitivity = "bounded",
  mechanism = "exponential"
)
}
\arguments{
\item{x}{Numeric vector of which the quantile will be taken.}

\item{quant}{Real number between 0 and 1 indicating which quantile to return.}

\item{eps}{Positive real number defining the epsilon privacy budget.}

\item{lower.bound}{Real number giving the global or public lower bound of x.}

\item{upper.bound}{Real number giving the global or public upper bound of x.}

\item{which.sensitivity}{String indicating which type of sensitivity to use.
Can be one of \{'bounded', 'unbounded', 'both'\}. If 'bounded' (default),
returns result based on bounded definition for differential privacy. If
'unbounded', returns result based on unbounded definition. If 'both',
returns result based on both methods \insertCite{Kifer2011}{DPpack}. Note
that if 'both' is chosen, each result individually satisfies (eps,
0)-differential privacy, but may not do so collectively and in composition.
Care must be taken not to violate differential privacy in this case.}

\item{mechanism}{String indicating which mechanism to use for differential
privacy. Currently the following mechanisms are supported: \{'exponential'\}.
See \code{\link{ExponentialMechanism}} for a description of the supported
mechanisms.}
}
\value{
Sanitized quantile based on the bounded and/or unbounded definitions
of differential privacy.
}
\description{
This function computes the differentially private quantile of an input vector
at a user-specified privacy level of epsilon.
}
\examples{
D <- stats::rnorm(500)
lower.bound <- -3 # 3 standard deviations below mean
upper.bound <- 3 # 3 standard deviations above mean

quant <- 0.25
eps <- 1
# Get 25th quantile satisfying pure 1-differential privacy
private.quantile <- quantileDP(D, quant, eps, lower.bound, upper.bound)
private.quantile

}
\references{
\insertRef{Dwork2006a}{DPpack}

\insertRef{Kifer2011}{DPpack}

\insertRef{Smith2011a}{DPpack}
}
