% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-methods.R
\name{as.DeponsRaster}
\alias{as.DeponsRaster}
\alias{as.DeponsRaster,RasterLayer-method}
\title{Convert a RasterLayer into a DeponsRaster}
\usage{
\S4method{as.DeponsRaster}{RasterLayer}(x)
}
\arguments{
\item{x}{A \code{RasterLayer}}
}
\value{
A \code{DeponsRaster}
}
\description{
Converts a \code{\link[raster:Raster-class]{RasterLayer}} into a \code{DeponsRaster}.
}
\details{
Maintains CRS (if defined) and value of NA cells. Currently DEPONS requires a fixed
cell size of 400 x 400 m, and cell size is set to this value.
}
\examples{
data(bathymetry)
bathymetry_RasterLayer <- as.raster(bathymetry)
bathymetry <- as.DeponsRaster(bathymetry_RasterLayer)
}
\seealso{
\code{\link{as.raster}} for converting a DeponsRaster into a RasterLayer
}
