% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bh.R
\name{segplot}
\alias{segplot}
\title{plot the age-pattern of coverage estimates}
\usage{
segplot(X, minA = 15, maxA = 75, minAges = 8, exact.ages = NULL,
  eOpen = NULL, deaths.summed = FALSE, log = FALSE)
}
\arguments{
\item{X}{\code{data.frame} with columns, \code{$pop1}, \code{$pop2}, \code{$deaths}, \code{$date1}, \code{$date2}, \code{$age}, \code{$sex}, and \code{$cod} (if there are more than 1 region/sex/intercensal period).}

\item{minA}{the lowest age to be included in search}

\item{maxA}{the highest age to be included in search (the lower bound thereof)}

\item{minAges}{the minimum number of adjacent ages to be used in estimating}

\item{exact.ages}{optional. A user-specified vector of exact ages to use for coverage estimation}

\item{eOpen}{optional. A user-specified value for remaining life-expectancy in the open age group.}

\item{deaths.summed}{logical. is the deaths column given as the total per age in the intercensal period (\code{TRUE}). By default we assume \code{FALSE}, i.e. that the average annual was given.}

\item{log}{logical. should we log the y axis?}
}
\value{
Function called for its graphical side effects
}
\description{
the SEG method works by averaging the coverage estimates over a range of ages. 
Users may wish to see the age pattern for diagnostic purposes.
}
\details{
All arguments are essentially the same as those given to \code{seg()}
}
\examples{
\dontrun{
segplot(Moz)
}
}
