% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggb.R
\name{ggbChooseAges}
\alias{ggbChooseAges}
\title{interactively determine ages to use for estimating coverage}
\usage{
ggbChooseAges(codi, minA = 15, maxA = 75, minAges = 8,
  exact.ages = NULL, maxit = 15, deaths.summed = FALSE)
}
\arguments{
\item{codi}{\code{data.frame} with columns, \code{$pop1}, \code{$pop2}, \code{$deaths}, \code{$date1}, \code{$date2}, and \code{$age}.}

\item{minA}{the lowest age to be included in search}

\item{maxA}{the highest age to be included in search (the lower bound thereof)}

\item{minAges}{the minimum number of adjacent ages to be used in estimating}

\item{exact.ages}{optional. A user-specified vector of exact ages to use for coverage estimation.}

\item{maxit}{the maximum number of clicks you can take. Default 15.}

\item{deaths.summed}{logical. is the deaths column given as the total per age in the intercensal period (\code{TRUE}). By default we assume \code{FALSE}, i.e. that the average annual was given.}
}
\value{
\code{data.frame} containing elements \code{$coverage}, \code{$lower}, \code{$upper}, and \code{ages}.
}
\description{
In a spreadsheet one would typically set up the GGB method to produce a plot that updates as the user changes the age range. This function implements that kind of work flow. This will be intuitive for spreadsheet users, but it does not scale well. Imagine you have 200 territorial units, then you would not want to repeat this task. \code{ggb()} does the same thing automatically. You can compare the age range you select manually with the one given back by \code{ggb()} as a diagnostic, for instance. To set up the plot device, just give a single year/region/sex of data. By default it will give the RMSE-optimized age range to start with, but you can specify a  vector of exact ages to use as well. All points are plotted, with a fitted line that has been set to a subset of the points, which is plotted in a different color. You can click any point to change the age range, and the plot updates accordingly, up to a maximum of 15 clicks so you don't waste your time. You can stop the plot by either clicking on the graphics device outside the plot area or clicking out the 15 tries (or more if you increase \code{maxit}).
}
\details{
If you want to send the results of this into \code{ggb()}, you can do so by setting \code{Exact.ages} to \code{seq(lower,upper,by=5)}, where \code{$lower}, and \code{$upper} are the results returned from \code{ggbChooseAges()} after you're done manually determining the age range.
}
\examples{
\dontrun{
# for interactive sessions only
# *click points to adjus age range used (yellow)
# *click in margin to stop and return coverage results
ggbChooseAges(Moz)
}
}
