% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D3partitionR.R
\name{plot.D3partitionR}
\alias{plot.D3partitionR}
\title{Plot D3partitionR object}
\usage{
\method{plot}{D3partitionR}(x, width = NULL, height = NULL,
  elementId = NULL, sizingPolicy = NULL, ...)
}
\arguments{
\item{x}{A D3partitionR object to plot}

\item{width}{width of the widget in pixel/percent}

\item{height}{height of the widget in pixel/percent}

\item{elementId}{html id of the widget}

\item{sizingPolicy}{sizing policy}

\item{...}{parameters for method consistency}
}
\description{
Plot D3partitionR object
}
\examples{
require(titanic)
require(data.table)
## Reading data
titanic_data = data.table(titanic::titanic_train)

##Agregating data to have unique sequence for the 4 variables
var_names=c('Sex','Embarked','Pclass','Survived')
data_plot=titanic_data[,.N,by=var_names]
data_plot[,(var_names):=lapply(var_names,function(x){data_plot[[x]]=paste0(x,' ',data_plot[[x]])
})]

## Plotting the chart
library("magrittr")
d3=D3partitionR() \%>\%
 add_data(data_plot,count = 'N',steps=c('Sex','Embarked','Pclass','Survived')) \%>\%
 add_title('Titanic')
\dontrun{
plot(d3)
}
}
