% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topDecileLift.R
\name{topDecileLift}
\alias{topDecileLift}
\title{Calculate top-decile lift}
\usage{
topDecileLift(predTest, depTest)
}
\arguments{
\item{predTest}{Vector with predictions (real-valued or discrete)}

\item{depTest}{Vector with true class labels}
}
\value{
Top-decile lift value
}
\description{
Calculates top-decile lift, a metric that expresses how the incidence in the 10\% customers
with the highest model predictions compares to the overall sample incidence. A top-decile
lift of 1 is expected for a random model. A top-decile lift of 3 indicates that in the 10\%
highest predictions, 3 times more postive cases are identified by the model than would be expected
for a random selection of instances.  The upper boundary of the metric depends on the sample
incidence and is given by 100\% / Indidence \%. E.g. when the incidence is 10\%, top-decile
lift can be no higher than 10.
}
\examples{
## Load response modeling predictions
data("response")
## Calculate top-decile lift for test sample results
tdl<-topDecileLift(response$test[,2],response$test[,1])
print(tdl)

}
\references{
Berry, M.J.A. and Linoff, G.S. (2004): "Data Mining Techniques: For Marketing, Sales, and
Customer Relationship Management - Second Edition". John Wiley & Sons.
}
\seealso{
\code{\link{liftTable}}, \code{\link{liftIndex}}, \code{\link{liftChart}}
}
\author{
Koen W. De Bock, \email{kdebock@audencia.com}
}
