% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augmatrix.R
\name{augmatrix}
\alias{augmatrix}
\title{Kemeny-equivalent augmented dissimilarity matrix}
\usage{
augmatrix(X)
}
\arguments{
\item{X}{A n by m data matrix, in which there are n judges and m objects to be judged. Each row is a ranking of the objects which are represented by the columns.}
}
\value{
A list containing the dissimilarity matrix and othe information about the augmented matrix. See details for detailed information.
}
\description{
Kemeny-equivalent augmented dissimilarity matrix
}
\details{
First the matrix is transformed with the tau_X rank correlation coeficient, then it is normalized. The output contains:
\tabular{llll}{
Delta \tab \tab \tab the augmented dissimilarity matrix\cr
Interaction \tab \tab  \tab the submatrix containnig the interactions individuals-items\cr
Objects \tab  \tab \tab the submatrix containing the within-items proximities\cr
Indiv \tab \tab \tab the submatrix containing the within-individuals proximities \cr
beta \tab \tab \tab the beta parameter \cr
alpha \tab \tab \tab the alpha parameter \cr
csi \tab \tab \tab the csi parameter \cr
res \tab \tab \tab the resume of th eaugmentation in terms of:\cr
\tab TauX \tab \tab tau_x rank correlation coefficient\cr
\tab Kendall \tab \tab kendall rank correlation coefficient\cr
\tab Spearman \tab \tab Spearman correlation coefficient
}
}
\references{
D'Ambrosio, A., Vera, J. F., & Heiser, W. J. (2022). Avoiding degeneracies in ordinal unfolding using Kemeny-equivalent dissimilarities for two-way two-mode preference rank data. Multivariate Behavioral Research, 57(4), 679-699.
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
\keyword{Kemeny-equivalent}
\keyword{Unfolding}
\keyword{dissimilarity}
