% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colordiff.R
\name{ciede2000}
\alias{ciede2000}
\title{Get the CIEDE2000 color difference between two CIELab values.}
\usage{
ciede2000(lab_color1, lab_color2, k_L = 1, k_C = 1, k_H = 1)
}
\arguments{
\item{lab_color1}{A vector with three components corresponding to a Lab value.}

\item{lab_color2}{A vector with three components corresponding to another Lab value.}

\item{k_L}{Weighting factor for the L component.}

\item{k_C}{Weighting factor for the C component.}

\item{k_H}{Weighting factor for the H component.}
}
\value{
The CIEDE2000 color difference between the two given values.
}
\description{
Get the CIEDE2000 color difference between two CIELab values.
}
\references{
Sharma, G., Wu, W., & Dalal, E. N. (2005). The CIEDE2000 color-difference formula: Implementation notes, supplementary test data, and mathematical observations. Color Research & Application: Endorsed by Inter-Society Color Council, The Colour Group (Great Britain), Canadian Society for Color, Color Science Association of Japan, Dutch Society for the Study of Color, The Swedish Colour Centre Foundation, Colour Society of Australia, Centre Français de la Couleur, 30(1), 21-30.
}
