% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poet.R
\name{poet}
\alias{poet}
\title{POET: Principal Orthogonal complEment Thresholding}
\usage{
poet(
  X,
  r = NULL,
  r.max = 10,
  thresh = "hard",
  lambda = NULL,
  gamma = 3.7,
  delta = 1e-04,
  method.r = "IC1"
)
}
\arguments{
\item{X}{Numeric matrix (T x N). T is the number of time periods (rows), N is the number of variables (columns).}

\item{r}{Integer or NULL. User-specified number of factors. If NULL, r is estimated automatically using \code{method.r}.}

\item{r.max}{Integer. Upper bound for the number of factors when estimating r. Default is 10.}

\item{thresh}{Character. Thresholding type for the residual covariance. Options: "hard", "soft", "scad", "adapt".
Default is "hard".}

\item{lambda}{Numeric or NULL. Thresholding parameter. If NULL, it defaults to \code{sqrt(log(N)/T)}.}

\item{gamma}{Numeric. Parameter for SCAD thresholding. Default is 3.7.}

\item{delta}{Numeric. Minimum eigenvalue bump to ensure positive definiteness of the residual covariance. Default is 1e-4.}

\item{method.r}{Character. Method to select the number of factors if r is NULL. Options: "IC1" (Bai & Ng, 2002)
or "ER" (Eigenvalue Ratio, Ahn & Horenstein, 2013).}
}
\value{
A list containing:
\item{Sigma.poet}{The estimated N x N POET covariance matrix.}
\item{Sigma.fact}{The estimated N x N low-rank (factor) covariance matrix.}
\item{Sigma.resid}{The estimated N x N thresholded residual covariance matrix.}
\item{F.hat}{Estimated factors (T x r).}
\item{Lambda.hat}{Estimated factor loadings (N x r).}
\item{r.hat}{The number of factors used (estimated or specified).}
\item{R.hat}{Same as Sigma.resid (for compatibility).}
}
\description{
Implements the POET method for large covariance matrix estimation (Fan, Liao & Mincheva, 2013).
The method assumes a factor model structure, estimates the low-rank component via PCA, and
applies thresholding to the sparse residual covariance matrix.
}
\examples{
# Examples should be fast and reproducible for CRAN checks
set.seed(2025)
T_obs <- 40; N_var <- 15; r_true <- 2

# Generate a simple factor model: X = F * Lambda' + U
Lambda <- matrix(stats::rnorm(N_var * r_true), N_var, r_true)
F_scores <- matrix(stats::rnorm(T_obs * r_true), T_obs, r_true)
U <- matrix(stats::rnorm(T_obs * N_var), T_obs, N_var)
X_sim <- F_scores \%*\% t(Lambda) + U  # T x N

# Apply POET (choose r via IC1; use soft thresholding)
res <- poet(X_sim, r = NULL, method.r = "IC1", thresh = "soft")
res$r.hat
res$Sigma.poet[1:5, 1:5]
}
\references{
Fan, J., Liao, Y., & Mincheva, M. (2013). Large covariance estimation by thresholding principal orthogonal complements.
\emph{Journal of the Royal Statistical Society: Series B}, 75(4), 603-680.
}
