% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv26_qpoisson_ppu.R
\name{cv26_qpoisson_ppu}
\alias{cv26_qpoisson_ppu}
\title{Calculate Process Performance Index using Poisson Distribution}
\usage{
cv26_qpoisson_ppu(data, residue_col, cleaning_event_col, usl_col)
}
\arguments{
\item{data}{A data frame containing the dataset.}

\item{residue_col}{Name of the column in `data` containing residue counts.}

\item{cleaning_event_col}{Name of the column in `data` used to group data by cleaning event.}

\item{usl_col}{Name of the column in `data` that contains the Upper Specification Limit (USL) for each group.}
}
\value{
A data frame with columns Method, Ppu, CI_Lower, and CI_Upper.
}
\description{
This function calculates the Process Performance Index (Ppu) for data 
assumed to follow a Poisson distribution. It includes a bootstrap method 
for estimating the confidence interval of the Ppu.
}
\examples{
cv26_qpoisson_ppu(Eq_Mic, "Mic", "CleaningEvent", "USL")
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
