% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv01_dfclean.R
\name{cv01_dfclean}
\alias{cv01_dfclean}
\title{Clean and preprocess residue data for stability and capability analysis}
\usage{
cv01_dfclean(data, residue_col, cleaning_event_col, usl_col)
}
\arguments{
\item{data}{A data frame containing one of drug active-ingredient residue (DAR), cleaning agent residue (CAR),
or microbial bioburden residue (Mic) data.}

\item{residue_col}{The name of the column containing the numeric residue data.}

\item{cleaning_event_col}{The name of the column containing the Cleaning Event data.}

\item{usl_col}{The name of the column containing the numeric upper specification limit (USL) data.}
}
\value{
A cleaned and pre-processed data frame such that all variables have no missing values, its CleaningEvent
is time-ordered categorical variable, and Residue and USL are numeric.
}
\description{
This function ensures data type and no missing data in residue_col, cleaning_event_col, usl_col of data their type. Furthermore, it changes cleaning_event_col to time ordered factor. It cleans and pre-processes the residue data for stability and capability analysis,
ensuring that it meets the necessary criteria for analysis.
}
\examples{
# Assume Eq_DAR, Eq_CAR, and Eq_Mic are loaded datasets

# Clean and preprocess residue data for Eq_DAR
Eq_DAR <- cv01_dfclean(data = Eq_DAR, residue_col = "DAR", usl_col = "USL", 
cleaning_event_col = "CleaningEvent")

# Clean and preprocess residue data for Eq_CAR
Eq_CAR <- cv01_dfclean(data = Eq_CAR, residue_col = "CAR", usl_col = "USL", 
cleaning_event_col = "CleaningEvent")

# Clean and preprocess residue data for Eq_Mic
Eq_Mic <- cv01_dfclean(data = Eq_Mic, residue_col = "Mic", usl_col = "USL", 
cleaning_event_col = "CleaningEvent")
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
