/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Objects;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCheck;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.operations.Operations;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.DateOffsetStrategy;

public class ExitCriteriaDaysOffsetCheck
extends BaseCheck {
    private static final String DAYS_OFFSET_WARNING = "Cohort Exit criteria: Days offset from start date should be greater than 0";

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.WARNING;
    }

    @Override
    protected void check(CohortExpression expression, WarningReporter reporter) {
        Operations.match(expression.endStrategy).isA(DateOffsetStrategy.class).then(s -> Operations.match((DateOffsetStrategy)s).when(dateOffsetStrategy -> Objects.equals((Object)DateOffsetStrategy.DateField.StartDate, (Object)dateOffsetStrategy.dateField) && 0 == dateOffsetStrategy.offset).then(() -> reporter.add(DAYS_OFFSET_WARNING, new Object[0])));
    }
}

