% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obtain_NLMELicense.R
\name{obtain_NLMELicense}
\alias{obtain_NLMELicense}
\title{Obtain NLME License}
\usage{
obtain_NLMELicense(
  InstallDir = Sys.getenv("INSTALLDIR"),
  ForceAuth = FALSE,
  ForceLicenseGet = FALSE,
  verbose = getOption("verbose")
)
}
\arguments{
\item{InstallDir}{A character string specifying the directory
where the NLME Engine is installed e.g., \code{INSTALLDIR} environment
variable. The \code{cadlicensingtool} executable is expected to be located
within this directory, or within a subdirectory specified by the
\code{PML_BIN_DIR} environment variable.}

\item{ForceAuth}{A logical value indicating whether to force
re-authentication even if already authenticated. Default is \code{FALSE}.}

\item{ForceLicenseGet}{A logical value indicating whether to force obtaining
the license even if already licensed. Default is \code{FALSE}.}

\item{verbose}{A logical value indicating whether to print verbose output.
Default is \code{getOption("verbose")}.}
}
\value{
A logical value indicating whether the license was successfully
  obtained.
}
\description{
This function attempts to authenticate and obtain an NLME license using the
specified installation directory and licensing tool.
}
\details{
This function checks for the presence of the necessary
  \code{appsettings.json} file as indicated by the \code{CAD_CONFIG_FILE} environment variable,
  runs the licensing tool to authenticate the user, and attempts to obtain
  an NLME license. It prints detailed messages if the \code{verbose}
  parameter is set to \code{TRUE}.
}
\examples{
\dontrun{
INSTALLDIR <- Sys.getenv("INSTALLDIR")
if (INSTALLDIR == "") INSTALLDIR <- "C:/Program Files/Certara/NLME_Engine"
result <- obtain_NLMELicense(INSTALLDIR, verbose = TRUE)
if (result) {
  message("License obtained successfully!")
} else {
  message("Failed to obtain license.")
}
}
}
