% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariateModel.R
\name{covariateModel}
\alias{covariateModel}
\title{Creates set of covariate effects}
\usage{
covariateModel(model)
}
\arguments{
\item{model}{Model object with covariates and covariate effects specified}
}
\value{
CovariateEffectModel class object
}
\description{
Use to create set of covariate effects to be checked during Stepwise or Shotgun
covariate search
}
\examples{
\dontrun{
# Define the model
model <- pkmodel(
  numCompartments = 2,
  data = pkData,
  ID = "Subject",
  Time = "Act_Time",
  A1 = "Amount",
  CObs = "Conc",
  workingDir = tempdir()
)

# Add Gender covariate of type categorical
model <- addCovariate(model,
  covariate = "Gender",
  type = "Categorical",
  effect = c("V2", "Cl2"),
  levels = c(0, 1),
  labels = c("Female", "Male")
)

# Add Bodyweight covariate of type continuous
model <- addCovariate(model,
  covariate = "BodyWeight",
  type = "Continuous",
  direction = "Backward",
  center = "Mean",
  effect = c("V", "Cl")
)
covariateModel(model)
}
}
\keyword{internal}
