% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script_generation.R
\name{generate_repro_script}
\alias{generate_repro_script}
\title{Generate Reproducible Script}
\usage{
generate_repro_script(
  script_file,
  source_script = NULL,
  analysis_name = "analysis",
  include_renv = TRUE,
  include_data_check = TRUE,
  include_session_info = TRUE
)
}
\arguments{
\item{script_file}{Character. Path to save the generated script}

\item{source_script}{Character. Original analysis script to include}

\item{analysis_name}{Character. Name for this analysis}

\item{include_renv}{Logical. Include renv initialization. Default TRUE.}

\item{include_data_check}{Logical. Include data verification. Default TRUE.}

\item{include_session_info}{Logical. Include session info at end. Default TRUE.}
}
\value{
Path to generated script
}
\description{
Generate an executable R script that includes all reproducibility information
including package versions, seeds, parameters, and data verification.
}
\examples{
\dontrun{
generate_repro_script(
  "analysis_reproducible.R",
  source_script = "analysis.R",
  analysis_name = "main_analysis"
)
}
}
