% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brierCurve.R
\name{brierCurve}
\alias{brierCurve}
\title{Calculates Brier Curve}
\usage{
brierCurve(labels, preds, resolution = 0.001)
}
\arguments{
\item{labels}{Vector with true class labels}

\item{preds}{Vector with predictions (real-valued or discrete)}

\item{resolution}{Value for the determination of percentile intervals. Defaults to 1/1000.}
}
\value{
object of the class \code{brierCurve} which is a list with the following components:
\item{brierCurveCost}{Cost-based Brier curve, represented as (cost,loss) coordinates}
\item{brierCurveSkew}{Skew-based Brier curve, represented as (skew,loss) coordinates}
\item{auc_brierCurveCost}{Area under the cost-based Brier curve.}
\item{auc_brierCurveSkew}{Area under the skew-based Brier curve.}
}
\description{
This function calculates the Brier curve (both in terms of cost and skew) based on a set of predictions generated by a binary classifier. Brier curves allow an evaluation of classifier performance in cost space. This code is an adapted version from the authors' original implementation, available through http://dmip.webs.upv.es/BrierCurves/BrierCurves.R.
}
\examples{
##load data
library(rpart)
data(BFP)
##generate random order vector
BFP_r<-BFP[sample(nrow(BFP),nrow(BFP)),]
size<-nrow(BFP_r)
##size<-300
train<-BFP_r[1:floor(size/3),]
val<-BFP_r[ceiling(size/3):floor(2*size/3),]
test<-BFP_r[ceiling(2*size/3):size,]
##train CART decision tree model
model=rpart(as.formula(Class~.),train,method="class")
##generate predictions for the tes set
preds<-predict(model,newdata=test)[,2]
##calculate brier curve
bc<-brierCurve(test[,"Class"],preds)
}
\references{
Hernandez-Orallo, J., Flach, P., & Ferri, C. (2011). Brier Curves: a New Cost-Based Visualisation of Classifier Performance. Proceedings of the 28th International Conference on Machine Learning (ICML-11), 585–592.
}
\seealso{
\code{\link{plotBrierCurve}}, \code{\link{CSMES.ensNomCurve}}
}
\author{
Koen W. De Bock, \email{kdebock@audencia.com}
}
