% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBO_EM_algorithm.R
\name{COMBO_EM_algorithm}
\alias{COMBO_EM_algorithm}
\title{EM-Algorithm Estimation of the Binary Outcome Misclassification Model}
\usage{
COMBO_EM_algorithm(
  Ystar,
  x_matrix,
  z_matrix,
  beta_start,
  gamma_start,
  tolerance = 1e-07,
  max_em_iterations = 1500,
  em_method = "squarem"
)
}
\arguments{
\item{Ystar}{A numeric vector of indicator variables (1, 2) for the observed
outcome \code{Y*}. There should be no \code{NA} terms. The reference category is 2.}

\item{x_matrix}{A numeric matrix of covariates in the true outcome mechanism.
\code{x_matrix} should not contain an intercept and no values should be \code{NA}.}

\item{z_matrix}{A numeric matrix of covariates in the observation mechanism.
\code{z_matrix} should not contain an intercept and no values should be \code{NA}.}

\item{beta_start}{A numeric vector or column matrix of starting values for the \eqn{\beta}
parameters in the true outcome mechanism. The number of elements in \code{beta_start}
should be equal to the number of columns of \code{x_matrix} plus 1.}

\item{gamma_start}{A numeric vector or matrix of starting values for the \eqn{\gamma}
parameters in the observation mechanism. In matrix form, the \code{gamma_start} matrix rows
correspond to parameters for the \code{Y* = 1}
observed outcome, with the dimensions of \code{z_matrix} plus 1, and the
gamma parameter matrix columns correspond to the true outcome categories
\eqn{M \in \{1, 2\}}. A numeric vector for \code{gamma_start} is
obtained by concatenating the gamma matrix, i.e. \code{gamma_start <- c(gamma_matrix)}.}

\item{tolerance}{A numeric value specifying when to stop estimation, based on
the difference of subsequent log-likelihood estimates. The default is \code{1e-7}.}

\item{max_em_iterations}{An integer specifying the maximum number of
iterations of the EM algorithm. The default is \code{1500}.}

\item{em_method}{A character string specifying which EM algorithm will be applied.
Options are \code{"em"}, \code{"squarem"}, or \code{"pem"}. The default and
recommended option is \code{"squarem"}.}
}
\value{
\code{COMBO_EM_algorithm} returns a data frame containing four columns. The first
column, \code{Parameter}, represents a unique parameter value for each row.
The next column contains the parameter \code{Estimates}, followed by the standard
error estimates, \code{SE}. The final column, \code{Convergence}, reports
whether or not the algorithm converged for a given parameter estimate.
}
\description{
Jointly estimate \eqn{\beta} and \eqn{\gamma} parameters from the true outcome
and observation mechanisms, respectively, in a binary outcome misclassification
model.
}
