% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmtfr_fg.R
\name{acmtfr_fg}
\alias{acmtfr_fg}
\title{Calculate function value of ACMTF}
\usage{
acmtfr_fg(
  x,
  Z,
  Y,
  alpha = 1,
  beta = rep(0.001, length(Z$object)),
  epsilon = 1e-08,
  pi = 0.5,
  mu = 1e-06
)
}
\arguments{
\item{x}{Vectorized parameters of the CMTF model.}

\item{Z}{Z object as generated by \code{\link[=setupCMTFdata]{setupCMTFdata()}}.}

\item{Y}{Dependent variable (regression part).}

\item{alpha}{Alpha value of the loss function as specified by Acar et al., 2014}

\item{beta}{Beta value of the loss function as specified by Acar et al., 2014}

\item{epsilon}{Epsilon value of the loss function as specified by Acar et al., 2014}

\item{pi}{Pi value of the loss function as specified by Van der Ploeg et al., 2025.}

\item{mu}{Ridge term parameter for calculation of the regression coefficients rho (default = 1e-6).}
}
\value{
Scalar of the loss function value (when manual=FALSE), otherwise a list containing all loss terms.
}
\description{
Calculate function value of ACMTF
}
\examples{
A = array(rnorm(108*2), c(108, 2))
B = array(rnorm(100*2), c(100, 2))
C = array(rnorm(10*2), c(10, 2))
D = array(rnorm(100*2), c(100,2))
E = array(rnorm(10*2), c(10,2))

df1 = reinflateTensor(A, B, C)
df2 = reinflateTensor(A, D, E)
datasets = list(df1, df2)
modes = list(c(1,2,3), c(1,4,5))
Z = setupCMTFdata(datasets, modes, normalize=FALSE)
Y = A[,1]

init = initializeACMTF(Z, 2, output="vect")
outcome = acmtfr_fg(init, Z, Y)
f = outcome$fn
g = outcome$gr
}
