% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_clip_basin.R
\name{cv_clip_basin}
\alias{cv_clip_basin}
\title{Get zones and areas that clip rasters from a given basin polygon}
\usage{
cv_clip_basin(za_rast, basin)
}
\arguments{
\item{za_rast}{\code{SpatRaster} of the zones and areas}

\item{basin}{\code{SpatVector} of the basin to clip to}
}
\value{
Returns a list with 3 elements: 1) \code{raster} (rasters of cell areas for each zone),
2) \code{area} total area of each zone in the basin, and 3) \code{zone} zone numbers.
}
\description{
Takes the \code{SpatRaster} that represents zones and areas and
clips them from polygon \code{basin}
}
\examples{
{
library(terra)
az_raster <- cv_zone_area_raster()
fpath <- system.file("extdata", "07BF001.shp", package = "CMIP6VisR")
basin_vector <- vect(fpath)
basin_areas <- cv_clip_basin(az_raster, basin_vector)
}

}
\seealso{
\code{\link{cv_basin_daily_precip}}
}
\author{
Kostas Andreadis
}
