% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_sf.R
\name{calculate_sf}
\alias{calculate_sf}
\title{calculate_sf}
\usage{
calculate_sf(par_ref, par_treat, C = 20)
}
\arguments{
\item{par_ref}{\code{summary.lm} object or 2-column matrix for the
treatment-free reference survival}

\item{par_treat}{\code{summary.lm} object or 2-column matrix for the
clonogenic survival after treatment}

\item{C}{colony number for which the survival fraction is calculated
(default = 20)}
}
\value{
survival fractions.
  If par_ref and par_treat are \code{summary.lm} objects,
  a scalar is returned.
  If par_ref and par_treat are matrices,
  a vector of the same length as nrow(par_treat) is returned
}
\description{
calculates the survival fraction according
  to the procedure presented in Brix et al. (2020), which is robust against
  cellular cooperation.
}
\examples{
seeded <- 10^(seq(1, 5, 0.5))
counted.ref <- 0.4 * 10^(seq(1, 5, 0.5) + rnorm(n = 9, 0, 0.1))^1.1
counted.treat <- 0.01 * 10^(seq(1, 5, 0.5) + rnorm(n = 9, 0, 0.1))^1.2
fit_ref <- pwr_reg(seeded = seeded, counted = counted.ref)
fit_treat <- pwr_reg(seeded = seeded, counted = counted.treat)
calculate_sf(par_ref = fit_ref, par_treat = fit_treat)
data("CFAdata")
D <- subset.data.frame(
  x = CFAdata,
  subset = cell.line == levels(CFAdata$cell.line)[1]
)
fit_ref <- pwr_reg(seeded = D$`Cells seeded`, counted = D$`0 Gy`)
fit_treat <- pwr_reg(seeded = D$`Cells seeded`, counted = D$`4 Gy`)
calculate_sf(par_ref = fit_ref, par_treat = fit_treat)
}
