% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{wrapper_svm}
\alias{wrapper_svm}
\title{SVM wrapper for CCI}
\usage{
wrapper_svm(
  formula,
  data,
  train_indices,
  test_indices,
  metric,
  metricfunc = NULL,
  eps = 1e-15,
  ...
)
}
\arguments{
\item{formula}{Model formula}

\item{data}{Data frame}

\item{train_indices}{Indices for training data}

\item{test_indices}{Indices for testing data}

\item{metric}{Type of metric ("RMSE", "Kappa" or "Log Loss")}

\item{metricfunc}{Optional user-defined function to calculate a custom performance metric.}

\item{eps}{Small value to avoid log(0) in LogLoss calculations. Default is 1e-15.}

\item{...}{Additional arguments passed to e1071::svm}
}
\value{
Performance metric (RMSE for continuous, Kappa for classification)
}
\description{
SVM wrapper for CCI
}
