% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar_annotation.R
\name{markerList2mat}
\alias{markerList2mat}
\title{Convert Marker List to a Weighted Matrix}
\usage{
markerList2mat(markerList)
}
\arguments{
\item{markerList}{A list where each element contains marker genes for different cell types or clusters. Each element of the list is a named list, where the names are the cell types and the values are the marker genes for that cell type. Generally, it is a list of the output of function \code{marker.select}.}
}
\value{
A matrix with rows representing cell types and columns representing unique marker genes. The values in the matrix represent the frequency of each gene as a marker in the corresponding cell type.
}
\description{
This function converts a list of marker genes for different cell types or clusters into a matrix, where rows represent cell types and columns represent marker genes. The matrix contains the frequency of each marker gene across the different cell types.
}
\examples{
data(toydata)

markers <- toydata$markers

marker.freq <- markerList2mat(list(markers))
print(marker.freq)

}
\seealso{
\code{\link{marker.select}} for select markers.
\code{\link{find.sig.genes}} for signature gene list.
}
