% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{getSelectedAttributes}
\alias{getSelectedAttributes}
\title{Extract names of the selected attributes}
\usage{
getSelectedAttributes(x, withTentative = FALSE)
}
\arguments{
\item{x}{an object of a class Boruta, from which relevant attributes names should be extracted.}

\item{withTentative}{if set to \code{TRUE}, Tentative attributes will be also returned.}
}
\value{
A character vector with names of the relevant attributes.
}
\description{
\code{getSelectedAttributes} returns a vector of names of attributes selected during a Boruta run.
}
\examples{
\dontrun{
data(iris)
#Takes some time, so be patient
Boruta(Species~.,data=iris,doTrace=2)->Bor.iris
print(Bor.iris)
print(getSelectedAttributes(Bor.iris))
}
}
