% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCx.R
\name{LCx.beeSurvFit}
\alias{LCx.beeSurvFit}
\title{Predict the Lethal Concentration at which \eqn{x\%} of organisms die for any
specified time-point for a \code{beeSurvFit} object}
\usage{
\method{LCx}{beeSurvFit}(
  object,
  X = 50,
  testType = "Chronic_Oral",
  timeLCx = NULL,
  concRange = NULL,
  nPoints = 100,
  ncores = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{beeSurvFit}}

\item{X}{Percentage of individuals dying (e.g., \eqn{50} for the \eqn{LC_{50}})}

\item{testType}{Test type for which the \eqn{LC_{X}} is calculated
amongst "Acute_Oral", "Acute_Contact", and "Chronic_Oral". Note that for
"Acute_Oral" and "Acute_Contact", the concentration will be reconstructed as
in the \link[=dataGUTS]{dataGUTS} function (not recommended as this might not
make sense for \eqn{LC_{X}} estimations. Default is "Chronic_Oral"}

\item{timeLCx}{A scalar giving the time at which  \eqn{LC_{x}} is predicted.
If \code{NULL}, the latest time point of the experiment used in the calibration is used}

\item{concRange}{A vector of length 2 with minimal and maximal value of the
range of concentration. If \code{NULL}, the range is define between 0 and the
highest tested concentration of the calibration experiment.}

\item{nPoints}{Number of time point in \code{concRange} between 0 and the
maximal concentration. 100 by default.}

\item{ncores}{Number of cores for parallelization}

\item{...}{Further arguments to be passed to generic methods}
}
\value{
A object of class \code{LCx} containing the results of the lethal concentration predictions
}
\description{
Predict the Lethal Concentration at which \eqn{x\%} of organisms die for any
specified time-point for a \code{beeSurvFit} object
}
\examples{
\donttest{
data(fitBetacyfluthrin_Chronic)
out <- LCx(fitBetacyfluthrin_Chronic,ncores=2)
}
}
