% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation_Stanlogisticdatatransform.R
\name{stan.logisticmodeltrans}
\alias{stan.logisticmodeltrans}
\title{stan.logisticmodeltrans}
\usage{
stan.logisticmodeltrans(
  z,
  y,
  randomprob,
  group_indicator,
  armleft,
  group,
  variable.inf,
  reg.inf
)
}
\arguments{
\item{z}{A vector of all treatment index data from the beginning of a trial}

\item{y}{A vector of all outcome data from the beginning of a trial}

\item{randomprob}{A named vector of randomisation probability to each arm}

\item{group_indicator}{A vector for the stage at which each patient was treated}

\item{armleft}{The number of treatment left in the platform (>2)}

\item{group}{The current stage}

\item{variable.inf}{Fixeffect/Mixeffect for logistic model parameter}

\item{reg.inf}{The information of how much accumulated information will be used}
}
\value{
A list of information require for the stan model including:
zdropped: The vector of treatment index for each patient
whose treatment arm is active at current stage.
ydropped: The vector of outcome index for each patient
whose treatment arm is active at current stage.
Ndropped: The total number of patients
that are treated with active treatment arms at current stage.
group_indicator_dropped: The vector of stage index for each patient
whose treatment arm is active at current stage.
zlevel: The active treatment arm index at current stage
xdummy: A design matrix transformed from zdropped and group_indicator_dropped for modelling
}
\description{
This function transform the data in trial simulation to the data required for stan modelling
}
\examples{
stan.logisticmodeltrans(
z = c(1,2,1,2,2,1,2,1),
y = c(0,0,0,0,1,1,1,1),
randomprob = matrix(c( 0.5, 0.5), ncol = 2, dimnames = list(c("Stage1"), c("1", "2"))),
group_indicator = c(1,1,1,1,1,1,1,1),
armleft = 2,
group = 1,
variable.inf = "Fixeffect",
reg.inf = "main")
}
\author{
Ziyan Wang
}
