% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_designs.R
\name{BLE_Ratio}
\alias{BLE_Ratio}
\title{Ratio BLE}
\source{
\url{https://www150.statcan.gc.ca/n1/en/catalogue/12-001-X201400111886}
}
\usage{
BLE_Ratio(ys, xs, x_nots, m = NULL, v = NULL, sigma = NULL, n = NULL)
}
\arguments{
\item{ys}{vector of sample observations or sample mean (\code{sigma} and \code{n} parameters will be required in this case).}

\item{xs}{vector with values for the auxiliary variable of the elements in the sample or sample mean.}

\item{x_nots}{vector with values for the auxiliary variable of the elements not in the sample.}

\item{m}{prior mean for the ratio between Y and X. If \code{NULL}, \code{mean(ys)/mean(xs)} will be used (non-informative prior).}

\item{v}{prior variance of the ratio between Y and X (bigger than \code{sigma^2}). If \code{NULL}, it will tend to infinity (non-informative prior).}

\item{sigma}{prior estimate of variability (standard deviation) of the ratio within the population. If \code{NULL}, sample variance of the ratio will be used.}

\item{n}{sample size. Necessary only if \code{ys} and \code{xs} represent sample means (will not be used otherwise).}
}
\value{
A list containing the following components: \itemize{
\item \code{est.beta} - BLE of Beta
\item \code{Vest.beta} - Variance associated with the above
\item \code{est.mean} - BLE for each individual not in the sample
\item \code{Vest.mean} - Covariance matrix associated with the above
\item \code{est.tot} - BLE for the total
\item \code{Vest.tot} - Variance associated with the above
}
}
\description{
Creates the Bayes Linear Estimator for the Ratio "estimator"
}
\examples{
ys <- c(10,8,6)
xs <- c(5,4,3.1)
x_nots <- c(1,20,13,15,-5)
m <- 2.5
v <- 10
sigma <- 2

Estimator <- BLE_Ratio(ys, xs, x_nots, m, v, sigma)
Estimator


# Same example but informing sample means and sample size instead of sample observations
ys <- mean(c(10,8,6))
xs <- mean(c(5,4,3.1))
n <- 3
x_nots <- c(1,20,13,15,-5)
m <- 2.5
v <- 10
sigma <- 2

Estimator <- BLE_Ratio(ys, xs, x_nots, m, v, sigma, n)
Estimator

}
\references{
Gonçalves, K.C.M, Moura, F.A.S and  Migon, H.S.(2014). Bayes Linear Estimation for Finite Population with emphasis on categorical data. Survey Methodology, 40, 15-28.
}
