% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_generics.R
\name{extract_method}
\alias{extract_method}
\alias{extract_data}
\alias{extract_mod}
\alias{extract_var_resp}
\alias{extract_var_exposure}
\alias{extract_var_cov}
\alias{extract_exp_sel_list_model}
\alias{extract_exp_sel_comp}
\alias{extract_var_selected}
\title{Extract elements from S3 objects}
\usage{
extract_data(x)

extract_mod(x)

extract_var_resp(x)

extract_var_exposure(x)

extract_var_cov(x)

extract_exp_sel_list_model(x)

extract_exp_sel_comp(x)

extract_var_selected(x)
}
\arguments{
\item{x}{An object to extract elements from}
}
\value{
\itemize{
\item \code{\link[=extract_data]{extract_data()}} extracts data used for the model fit.
\item \code{\link[=extract_mod]{extract_mod()}} extracts the model fit object.
\item \code{\link[=extract_var_resp]{extract_var_resp()}} extracts the response variable name
\item \code{\link[=extract_var_exposure]{extract_var_exposure()}} extracts the exposure metric name
\item \code{\link[=extract_var_cov]{extract_var_cov()}} extracts the covariates name
\item \code{\link[=extract_exp_sel_list_model]{extract_exp_sel_list_model()}} extracts the list of fitted models for
each exposure metrics.
\item \code{\link[=extract_exp_sel_comp]{extract_exp_sel_comp()}} extracts the comparison results of the exposure
metrics.
\item \code{\link[=extract_var_selected]{extract_var_selected()}} extracts the selected variables (both exposure
and covariates)in the final model after covariate selection.
}
}
\description{
S3 methods are defined for \verb{ermod_*} (see \link{extract_ermod}) and
\verb{ersim_*} (see \link{extract_ersim}) classes.
}
