% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustCpObj.R
\name{plot.ClustCpObj}
\alias{plot.ClustCpObj}
\title{Plot estimated partition}
\usage{
\method{plot}{ClustCpObj}(
  x,
  y = NULL,
  loss = "VI",
  maxNClusters = 0,
  nRuns = 16,
  maxZealousAttempts = 10,
  ...
)
}
\arguments{
\item{x}{an object of class \code{ClustCpObj}.}

\item{y}{parameter of the generic method.}

\item{loss}{The loss function used to estimate the final partition, it can be "VI", "binder", "omARI", "NVI", "ID", "NID".}

\item{maxNClusters}{maximum number of clusters in salso procedure.}

\item{nRuns}{number of runs in salso procedure.}

\item{maxZealousAttempts}{maximum number of zealous attempts in salso procedure.}

\item{...}{parameter of the generic method.}
}
\value{
The function returns a ggplot object representing the time series or the epidemic diffusions colored according to the final partition.
}
\description{
The \code{plot} method plots the estimates partition through the salso algorithm, for a \code{ClustCpObj} class object.
}
\examples{

data("stock_uni")

params_uni <- list(a = 1,
                   b = 1,
                   c = 1,
                   phi = 0.1)

out <- clust_cp(data = stock_uni[1:3,], n_iterations = 1000, n_burnin = 100,
                L = 1, q = 0.5, B = 500, params = params_uni, kernel = "ts")

plot(out)


}
