% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/union_closed.R
\name{union_closed}
\alias{union_closed}
\alias{union_closed.TidySet}
\title{Union closed sets}
\usage{
union_closed(object, ...)

\method{union_closed}{TidySet}(object, sets = NULL, ...)
}
\arguments{
\item{object}{A TidySet object.}

\item{...}{Other named arguments passed to \code{FUN}.}

\item{sets}{The name of the sets to be used.}
}
\value{
A logical value: \code{TRUE} if the combinations of sets produce already
existing sets, \code{FALSE} otherwise.
}
\description{
Tests if a given object is union-closed.
}
\examples{
l <- list(A = "1",
     B = c("1", "2"),
     C = c("2", "3", "4"),
     D = c("1", "2", "3", "4")
)
TS <- tidySet(l)
union_closed(TS)
union_closed(TS, sets = c("A", "B", "C"))
union_closed(TS, sets = c("A", "B", "C", "D"))
}
