% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/remove_column.R
\name{remove_column}
\alias{remove_column}
\alias{remove_column,TidySet,character,character-method}
\title{Remove column}
\usage{
remove_column(object, slot, column_names)

\S4method{remove_column}{TidySet,character,character}(object, slot, column_names)
}
\arguments{
\item{object}{A TidySet object.}

\item{slot}{A TidySet slot.}

\item{column_names}{The name of the columns.}
}
\value{
A \code{TidySet} object.
}
\description{
Removes column from a slot of the TidySet object.
}
\section{Methods (by class)}{
\itemize{
\item \code{remove_column(object = TidySet, slot = character, column_names = character)}: Remove columns to any slot

}}
\examples{
x <- data.frame(sets = c(rep("A", 5), rep("B", 5)),
                elements = c(letters[1:5], letters[3:7]),
                extra = sample(c("YES", "NO"), 10, replace = TRUE))
TS <- tidySet(x)
TS
remove_column(TS, "relations", "extra")
}
\seealso{
\code{\link[=rename_set]{rename_set()}}

Other column: 
\code{\link{add_column}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group}()},
\code{\link{group_by.TidySet}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets}()},
\code{\link{name_sets<-}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{column}
\concept{methods}
