% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_func.R
\name{ResultTableSummary2}
\alias{ResultTableSummary2}
\title{Generate a summary table of the outputs all different methods given the data}
\usage{
ResultTableSummary2(y,X,A,LinearT=FALSE,
                           nchain=3,niter=100,nburn=20,nthin=1)
}
\arguments{
\item{y}{vector of counts, must be non-negative}

\item{X}{matrix of covariates, numeric}

\item{A}{adjacency matrix, numeric}

\item{LinearT}{logical, whether to fit a linear or non-linear temporal trend}

\item{nchain}{positive integer, number of MCMC chains to be run}

\item{niter}{positive integer, number of iterations in each chain}

\item{nburn}{non-negative integer, number of iterations to be discarded as burn-in samples}

\item{nthin}{positive integer, thinning interval}
}
\value{
summary tables for the different methods
}
\description{
Fits BSTP, BSTNB and BSTZINB (with linear or non-linear temporal trend) to a given data and summarizes the results in a table
}
\examples{
data(simdat)
y <- simdat$y
X <- cbind(simdat$V1,simdat$x)
data(county.adjacency)
data(USAcities)
IAcities <- subset(USAcities,state_id=="IA")
countyname <- unique(IAcities$county_name)
A <- get_adj_mat(county.adjacency,countyname,c("IA"))
\donttest{
ResultTableSummary2(y, X, A, LinearT=TRUE, nchain=3, niter=100, nburn=20, nthin=1)
}
}
