% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udf.R
\name{get_udf}
\alias{get_udf}
\alias{get_udf.cosmos_container}
\alias{list_udfs}
\alias{create_udf}
\alias{create_udf.cosmos_container}
\alias{replace_udf}
\alias{replace_udf.cosmos_container}
\alias{replace_udf.cosmos_udf}
\alias{delete_udf}
\alias{delete_udf.cosmos_container}
\alias{delete_udf.cosmos_udf}
\title{Methods for working with Azure Cosmos DB user-defined functions}
\usage{
get_udf(object, ...)

\method{get_udf}{cosmos_container}(object, funcname, ...)

list_udfs(object, ...)

create_udf(object, ...)

\method{create_udf}{cosmos_container}(object, funcname, body, ...)

replace_udf(object, ...)

\method{replace_udf}{cosmos_container}(object, funcname, body, ...)

\method{replace_udf}{cosmos_udf}(object, body, ...)

delete_udf(object, ...)

\method{delete_udf}{cosmos_container}(object, funcname, confirm = TRUE, ...)

\method{delete_udf}{cosmos_udf}(object, ...)
}
\arguments{
\item{object}{A Cosmos DB container object, as obtained by \code{get_cosmos_container} or \code{create_cosmos_container}, or for \code{delete_udf.cosmos_udf}, the function object.}

\item{...}{Optional arguments passed to lower-level functions.}

\item{funcname}{The name of the user-defined function.}

\item{body}{For \code{create_udf} and \code{replace_udf}, the body of the function. This can be either a character string containing the source code, or the name of a source file.}

\item{confirm}{For \code{delete_udf}, whether to ask for confirmation before deleting.}
}
\value{
For \code{get_udf} and \code{create_udf}, an object of class \code{cosmos_udf}. For \code{list_udfs}, a list of such objects.
}
\description{
Methods for working with Azure Cosmos DB user-defined functions
}
\details{
These are methods for working with user-defined functions (UDFs) in Azure Cosmos DB using the core (SQL) API. In the Cosmos DB model, UDFs are written in JavaScript and associated with a container.
}
\examples{
\dontrun{

endp <- cosmos_endpoint("https://myaccount.documents.azure.com:443/", key="mykey")
db <- get_cosmos_database(endp, "mydatabase")

# importing the Star Wars data from dplyr
cont <- endp \%>\%
    get_cosmos_database(endp, "mydatabase") \%>\%
    create_cosmos_container(db, "mycontainer", partition_key="sex")

create_udf(cont, "times2", "function(x) { return 2*x; }")

list_udfs(cont)

# UDFs in queries are prefixed with the 'udf.' identifier
query_documents(cont, "select udf.times2(c.height) t2 from cont c")

delete_udf(cont, "times2")

}
}
\seealso{
\link{cosmos_container}, \link{get_stored_procedure}
}
