#' Example Dataset for correlation
#'
#' A small synthetic dataset included with *AssumpSure* for demonstrating 
#' correlation analysis in the Correlation tab.
#'
#' The file is stored in `inst/extdata/correlation.csv`.
#'
#' All values are synthetic, created only for demonstration; no human data were used,
#' and no ethical approval or consent is required.
#'
#' @format A CSV file with 33 rows and 12 columns:
#' \describe{
#'   \item{sample_id}{Sample identifier.}
#'   \item{mpg}{Miles per gallon.}
#'   \item{cyl}{Number of cylinders.}
#'   \item{disp}{Displacement (cu. in.).}
#'   \item{hp}{Gross horsepower.}
#'   \item{drat}{Rear axle ratio.}
#'   \item{wt}{Weight (1000 lbs).}
#'   \item{qsec}{1/4 mile time.}
#'   \item{vs}{Engine shape (0 = V-shaped, 1 = straight).}
#'   \item{am}{Transmission (0 = automatic, 1 = manual).}
#'   \item{gear}{Number of forward gears.}
#'   \item{carb}{Number of carburetors.}
#' }
#'
#' @source Simulated data generated by the author.
#'
#' @examples
#' read.csv(system.file("extdata", "correlation.csv", package = "AssumpSure"))
#' @name correlation
NULL
