% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hiatus.R
\docType{methods}
\name{hiatus}
\alias{hiatus}
\alias{hiatus-method}
\alias{hiatus,numeric,numeric-method}
\alias{hiatus,EventsMCMC,missing-method}
\alias{hiatus,EventsMCMC-method}
\alias{hiatus,PhasesMCMC,missing-method}
\title{Hiatus Between Two Dates}
\usage{
hiatus(x, y, ...)

\S4method{hiatus}{numeric,numeric}(x, y, level = 0.95)

\S4method{hiatus}{EventsMCMC,missing}(x, level = 0.95)

\S4method{hiatus}{PhasesMCMC,missing}(x, level = 0.95)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, \code{x} must be an
\code{\linkS4class{PhasesMCMC}} or an \code{\linkS4class{EventsMCMC}} object.}

\item{...}{Currently not used.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}
}
\value{
The endpoints of the hiatus between successive events/phases
(at a given \code{level}).
}
\description{
Tests for the existence of a hiatus between two parameters.
}
\details{
Finds if a gap exists between two dates and returns the longest interval
that satisfies \eqn{P(x < HiatusInf < HiatusSup < y | M) = level}

The hiatus between two successive phases is the longest interval that
satisfies
\eqn{P(Phase1Max < IntervalInf < IntervalSup < Phase2Min | M) = level}
(this assumes that the phases are in temporal order constraint).
}
\section{Methods (by class)}{
\itemize{
\item \code{hiatus(x = numeric, y = numeric)}: Returns a length-three \code{\link{numeric}} vector (terminal times
and hiatus duration, if any).

\item \code{hiatus(x = EventsMCMC, y = missing)}: Returns a \code{\linkS4class{TimeRange}} object.

\item \code{hiatus(x = PhasesMCMC, y = missing)}: Returns a \code{\linkS4class{TimeRange}} object.

}}
\examples{
## Coerce to MCMC
eve <- as_events(mcmc_events, calendar = CE(), iteration = 1)
eve <- eve[1:10000, ]

## Test for anteriority
older(eve)

## Test for hiatus
hia <- hiatus(eve)
as.data.frame(hia)
}
\seealso{
Other time ranges: 
\code{\link{boundaries}()},
\code{\link{transition}()}
}
\author{
A. Philippe, M.-A. Vibet, N. Frerebeau
}
\concept{time ranges}
