% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Air_methods.R
\name{rnormCS}
\alias{rnormCS}
\title{Generate normal samples (Compound Symmetry)}
\usage{
rnormCS(n, p, rho = 0.5, means = 0, variances = 1)
}
\arguments{
\item{n}{Number of observations.}

\item{p}{Number of features.}

\item{rho}{Common correlation coefficient.}

\item{means}{Numeric vector of feature means (length \eqn{1} or \eqn{p}).}

\item{variances}{Numeric vector of feature variances (length \eqn{1} or
\eqn{p}).}
}
\value{
A numeric \eqn{n \times p} matrix with the specified correlation,
means, and variances.
}
\description{
\code{rnormCS} efficiently generates samples from a multivariate
normal distribution with compound symmetry correlation structure (all
features equally correlated).
}
\examples{
X1 <- rnormCS(10, 5)
X2 <- rnormCS(10, 5, rho = 0.3, means = 2, variances = 4)
X3 <- rnormCS(10, 5, rho = 0.4, means = 1:5, variances = 3:7)
}
