% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATA_Transform.R
\name{ATA.Transform}
\alias{ATA.Transform}
\title{Transformation Techniques for The ATAforecasting}
\usage{
ATA.Transform(
  X,
  tMethod = c("Box_Cox", "Sqrt", "Reciprocal", "Log", "NegLog", "Modulus",
    "BickelDoksum", "Manly", "Dual", "YeoJohnson", "GPower", "GLog"),
  tLambda,
  tShift = 0,
  bcMethod = c("loglik", "guerrero"),
  bcLower = 0,
  bcUpper = 5
)
}
\arguments{
\item{X}{a numeric vector or time series of class \code{ts} or \code{msts} for in-sample.}

\item{tMethod}{Box-Cox power transformation family is consist of "Box_Cox", "Sqrt", "Reciprocal", "Log", "NegLog",
"Modulus", "BickelDoksum", "Manly", "Dual", "YeoJohnson", "GPower", "GLog" in ATAforecasting package. If the transformation process needs shift parameter,
\code{ATA.Transform} will calculate required shift parameter automatically.}

\item{tLambda}{Box-Cox power transformation family parameter. Default is NULL. When lambda is set as NULL, required "lambda" parameter will be calculated automatically based on "bcMethod, bcLower, and bcUpper".}

\item{tShift}{Box-Cox power transformation family shifting parameter. Default is 0. When "transform.method" is selected, required shifting parameter will be calculated automatically according to dataset.}

\item{bcMethod}{Choose method to be used in calculating lambda. "loglik" is default. Other method is "guerrero" (Guerrero, V.M. (1993)).}

\item{bcLower}{Lower limit for possible lambda values. The lower value is limited by -5. Default value is 0.}

\item{bcUpper}{Upper limit for possible lambda values. The upper value is limited by 5. Default value is 1.}
}
\value{
A list object consists of transformation parameters and transformed data.
\code{ATA.Transform} is a list containing at least the following elements:
\itemize{
	 \item{trfmX}   : Transformed data
	 \item{tLambda} : Box-Cox power transformation family parameter
	 \item{tShift}  : Box-Cox power transformation family shifting parameter
}
}
\description{
The function provides the applicability of different types of transformation techniques for the data to which the Ata method will be applied.
The \code{ATA.Transform} function works with many different types of inputs.
}
\references{
#'\insertRef{tukey1957}{ATAforecasting}

#'\insertRef{boxcox1964}{ATAforecasting}

#'\insertRef{manly1976}{ATAforecasting}

#'\insertRef{johndraper1980}{ATAforecasting}

#'\insertRef{bickeldoksum1982}{ATAforecasting}

#'\insertRef{sakia1992}{ATAforecasting}

#'\insertRef{guerrero1993}{ATAforecasting}

#'\insertRef{yeojohn2000}{ATAforecasting}

#'\insertRef{glog2002}{ATAforecasting}

#'\insertRef{neglog2005}{ATAforecasting}

#'\insertRef{yang2006}{ATAforecasting}

#'\insertRef{gpower2013}{ATAforecasting}
}
\keyword{Ata}
\keyword{Bickel--Doksum}
\keyword{Box--Cox}
\keyword{Guerrero}
\keyword{Manly}
\keyword{Yeo--Johnson}
\keyword{dual}
\keyword{glog}
\keyword{gpower}
\keyword{neglog}
\keyword{transformation}
