% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_session_num}
\alias{create_session_num}
\title{Creates a new column by converting session_id column into a numeric}
\usage{
create_session_num(data, name = "session_num")
}
\arguments{
\item{data}{tbl. Data frame containing the \code{session_id} column.}

\item{name}{character of length 1. The name of the newly created and appended
column. Default: \code{session_num}}
}
\value{
tbl. The input data frame with the \code{name} column added.
}
\description{
Creates a new column which contains the parsed numeric value for the
visit. Annual visits are set to integers, where 0 = baseline, 1 = year 1,
and so on. Mid-years are defined as 0.5 increments of the
prior annual visits, e.g., 0.5 = between baseline and year 1,
1.5 = between year 1 and 2, and so on.
}
\examples{
# Example data
dat <- tibble::tibble(
  participant_id = c("A123", "A123", "A123", "A123"),
  session_id = c("ses-00S", "ses-00A", "ses-00M", "ses-01A"),
  a = c(1, 2, 3, 4),
  b = c(10, 11, 12, NA)
)

# Create a new column (default: `session_num`) with numeric session
create_session_num(
  dat
)

# Create a new column called `num` that contains the session numbers
create_session_num(
  dat,
  name = "num"
)

}
