% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh_aseba.R
\name{compute_mh_p_abcl__dsm__adhd_tscore}
\alias{compute_mh_p_abcl__dsm__adhd_tscore}
\title{Compute "Adult Behavior Checklist [Parent] (DSM-5 Oriented Scale - ADHD):
T-score"}
\usage{
compute_mh_p_abcl__dsm__adhd_tscore(
  data,
  data_norm = NULL,
  name = "mh_p_abcl__dsm__adhd_tscore",
  col_age = "mh_p_abcl__cg2__age_001",
  col_sex = "mh_p_abcl__cg2_sex",
  max_na = 0,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{data_norm}{tbl. Data frame containing the norm (T-score) values.
see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{name}{character. Name of the summary score column.}

\item{col_age}{character, name of the age column. see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{col_sex}{character, name of the sex column. see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary score.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_p_abcl__dsm__adhd_tscore}
Adult Behavior Checklist [Parent] (DSM-5 Oriented Scale - ADHD):
T-score
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_abcl__aggr__adhd_001}
\item \code{mh_p_abcl__attn__adhd_001}
\item \code{mh_p_abcl__attn__adhd_002}
\item \code{mh_p_abcl__attn__adhd_003}
\item \code{mh_p_abcl__attn__adhd_004}
\item \code{mh_p_abcl__attn__adhd_005}
\item \code{mh_p_abcl__attn__adhd_006}
\item \code{mh_p_abcl__attn__adhd_007}
\item \code{mh_p_abcl__othpr__adhd_001}
\item \code{mh_p_abcl__othpr__adhd_002}
\item \code{mh_p_abcl__othpr__adhd_003}
\item \code{mh_p_abcl__othpr__adhd_004}
\item \code{mh_p_abcl__rule__adhd_001}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} maximally 0 of 13 items missing
}
}
\examples{
\dontrun{
compute_mh_p_abcl__dsm__adhd_tscore(data) |>
  select(
    any_of(c("mh_p_abcl__dsm__adhd_tscore", vars_mh_p_abcl__dsm__adhd))
  )
}
}
\seealso{
\code{\link[=compute_mh_p_abcl__dsm__adhd_nm]{compute_mh_p_abcl__dsm__adhd_nm()}}
}
