% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extent.R
\name{viewExtent}
\alias{viewExtent}
\title{View extent/bbox of spatial objects interactively}
\usage{
viewExtent(
  x,
  map = NULL,
  popup = NULL,
  layer.name = NULL,
  alpha.regions = 0.2,
  label = NULL,
  ...
)
}
\arguments{
\item{x}{either a Raster*, sf* or Spatial* object}

\item{map}{a leaflet or mapview map the extent should be added to. If NULL
standard background layers are created.}

\item{popup}{a \code{list} of HTML strings with the popup contents, usually
created from \code{\link{popupTable}}. See \code{\link{addControl}} for
details.}

\item{layer.name}{the name of the layer to be shown on the map.}

\item{alpha.regions}{opacity of the fills or the raster layer(s).}

\item{label}{a character vector of labels to be shown on mouseover. See
\code{\link{addControl}} for details.}

\item{...}{additional arguments passed on to \code{\link{addRectangles}}}
}
\description{
This function produces an interactive view of the extent/bbox
of the supplied spatial object
}
\examples{
library(leaflet)

viewExtent(breweries)
viewExtent(franconia) + breweries
mapview(franconia) \%>\% leafem::addExtent(franconia, fillColor = "yellow")
leaflet() \%>\% addProviderTiles("OpenStreetMap") \%>\% leafem::addExtent(breweries)
leaflet() \%>\% addProviderTiles("OpenStreetMap") \%>\% leafem::addExtent(breweries)

}
\author{
Tim Appelhans
}
