% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addLargeFeatures.R
\name{addLargeFeatures}
\alias{addLargeFeatures}
\title{Add moderately large datasets with up to ~100k features to a map.}
\usage{
addLargeFeatures(map, data, color = "#03F", weight = 1, radius = 8,
  opacity = 1, fillOpacity = 0.6, canvasOpacity = 0.5,
  group = deparse(substitute(data)), maxpoints = getMaxFeatures(data),
  attributes = NULL, ...)
}
\arguments{
\item{map}{a mapview or leaflet object.}

\item{data}{the data to be added to the map.}

\item{color}{color of the features. This can be a single character value,
a vector of character values or a function that takes argument \code{n} to
create a vector of \code{n} colors.}

\item{weight}{the weight of the lines.}

\item{radius}{the radius of the circleMarkers (ignored for lines/polygons).}

\item{opacity}{the opacity of the stroke paths.}

\item{fillOpacity}{opacity of the fill (for circleMarkers and polygons).}

\item{canvasOpacity}{the opacity of features when rendered on canvas.}

\item{group}{the name of the group the data layer should belong to.
THIS NEEDS TO BE A VALID CHARACTER STRING, I.E. CANNOT BE 'NA' OR 'NULL'!}

\item{maxpoints}{see \code{\link{mapview}} for details.}

\item{attributes}{an optional attribute table (data.frame) to be used for
popups. If NULL (the default) popups will show only the feature ID.}

\item{...}{currently not used.}
}
\description{
This function allows users to add moderately sized datasets to a leaflet
or mapview map. Things are drawn on a html canvas for performance. Feature
querying is supported but only at higher zoom levels to preserve performance.
}
\examples{
\dontrun{
library(sf)
library(ggmap)

data(crime)
crime <- crime[complete.cases(crime), ]
crime_sf <- st_as_sf(crime, coords = c("lon", "lat"), crs = "+init=epsg:4326")

mapview(crime_sf, zcol = "offense", cex = 3)

}


}
