
<!-- README.md is generated from README.Rmd. Please edit that file -->

<!-- badges: start -->

[![Project Status: Active – The project has reached a stable, usable
state and is being actively
developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![R-CMD-check](https://github.com/ropensci/rvertnet/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/ropensci/rvertnet/actions/workflows/R-CMD-check.yaml)
[![Codecov test
coverage](https://codecov.io/gh/ropensci/rvertnet/branch/master/graph/badge.svg)](https://app.codecov.io/gh/ropensci/rvertnet?branch=master)
[![rstudio mirror
downloads](https://cranlogs.r-pkg.org/badges/rvertnet)](https://github.com/r-hub/cranlogs.app)
[![cran
version](https://www.r-pkg.org/badges/version/rvertnet)](https://cran.r-project.org/package=rvertnet)

<!-- badges: end -->

# rvertnet

`rvertnet` is a client for interacting with
[VertNet.org](http://vertnet.org/).

VertNet.org API docs:
<https://github.com/VertNet/webapp/wiki/The-API-search-function>

## Installation

Stable CRAN version

``` r
install.packages("rvertnet")
```

Development version from GitHub

``` r
remotes::install_github("ropensci/rvertnet", build_vignettes = TRUE)
```

## [Get started](https://docs.ropensci.org/rvertnet/articles/rvertnet.html)

[View vignette on ropensci
website](https://docs.ropensci.org/rvertnet/articles/rvertnet.html)

Or, view vignette locally in your web browser

``` r
browseVignettes("rvertnet")
```

Or, view vignette in the Rstudio help pane

``` r
vignette("rvertnet")
```

## Contributors

  - Dave Slager [@slager](https://github.com/slager)
  - Scott Chamberlain [@sckott](https://github.com/sckott)
  - Chris Ray [@Pika8tona](https://github.com/Pika8tona)
  - Vijay Barve [@vijaybarve](https://github.com/vijaybarve)

## Meta

  - Please [report any issues or
    bugs](https://github.com/ropensci/rvertnet/issues).
  - License: MIT
  - Get citation information for `rvertnet` in R doing `citation(package
    = 'rvertnet')`
  - Please note that this package is released with a [Contributor Code
    of Conduct](https://ropensci.org/code-of-conduct/). By contributing
    to this project, you agree to abide by its terms.
