/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import kafka.message.ByteBufferBackedInputStream;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.ByteBufferMessageSet$$anonfun$kafka$message$ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.Message;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import scala.Function1;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.package$;
import scala.runtime.LongRef;

public final class ByteBufferMessageSet$
implements ScalaObject {
    public static final ByteBufferMessageSet$ MODULE$;

    static {
        new ByteBufferMessageSet$();
    }

    public final ByteBuffer kafka$message$ByteBufferMessageSet$$create(AtomicLong offsetCounter$1, CompressionCodec compressionCodec, Seq messages) {
        DataOutputStream output$1;
        ByteBuffer byteBuffer;
        if (messages.size() == 0) {
            byteBuffer = MessageSet$.MODULE$.Empty().buffer();
        } else {
            CompressionCodec compressionCodec2 = compressionCodec;
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
                ByteBuffer buffer$1 = ByteBuffer.allocate(MessageSet$.MODULE$.messageSetSize(messages));
                messages.foreach(new anonfun$kafka$message$ByteBufferMessageSet$$create$1(offsetCounter$1, buffer$1));
                buffer$1.rewind();
                byteBuffer = buffer$1;
            } else {
                ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(MessageSet$.MODULE$.messageSetSize(messages));
                output$1 = new DataOutputStream(CompressionFactory$.MODULE$.apply(compressionCodec, byteArrayStream));
                LongRef offset$1 = new LongRef(-1L);
                messages.foreach(new anonfun$kafka$message$ByteBufferMessageSet$$create$2(offsetCounter$1, output$1, offset$1));
                byte[] bytes = byteArrayStream.toByteArray();
                Message message = new Message(bytes, compressionCodec);
                ByteBuffer buffer = ByteBuffer.allocate(message.size() + MessageSet$.MODULE$.LogOverhead());
                this.writeMessage(buffer, message, offset$1.elem);
                buffer.rewind();
                byteBuffer = buffer;
            }
        }
        return byteBuffer;
        finally {
            output$1.close();
        }
    }

    public ByteBufferMessageSet decompress(Message message) {
        ByteArrayOutputStream outputStream$1 = new ByteArrayOutputStream();
        ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(message.payload());
        byte[] intermediateBuffer$1 = new byte[1024];
        InputStream compressed$1 = CompressionFactory$.MODULE$.apply(message.compressionCodec(), inputStream);
        ((Stream)package$.MODULE$.Stream().continually(new anonfun.decompress.1(intermediateBuffer$1, compressed$1)).takeWhile((Function1)new anonfun.decompress.2())).foreach(new anonfun.decompress.3(outputStream$1, intermediateBuffer$1));
        ByteBuffer outputBuffer = ByteBuffer.allocate(outputStream$1.size());
        outputBuffer.put(outputStream$1.toByteArray());
        outputBuffer.rewind();
        return new ByteBufferMessageSet(outputBuffer);
        finally {
            compressed$1.close();
        }
    }

    public void writeMessage(ByteBuffer buffer, Message message, long offset) {
        buffer.putLong(offset);
        buffer.putInt(message.size());
        buffer.put(message.buffer());
        message.buffer().rewind();
    }

    private ByteBufferMessageSet$() {
        MODULE$ = this;
    }
}

