/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.DataBlockResults;
import jdplus.toolkit.base.core.ssf.DataResults;
import jdplus.toolkit.base.core.ssf.MatrixResults;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.StateStorage;
import jdplus.toolkit.base.core.ssf.univariate.ISmoothingResults;

public class DefaultSmoothingResults
extends StateStorage
implements ISmoothingResults {
    private final DataResults e;
    private final DataResults f;
    private final MatrixResults N;
    private final DataBlockResults R;

    protected DefaultSmoothingResults(boolean cov, boolean err) {
        super(StateInfo.Smoothed, cov);
        if (err) {
            this.e = new DataResults();
            this.f = new DataResults();
            this.N = new MatrixResults();
            this.R = new DataBlockResults();
        } else {
            this.e = null;
            this.f = null;
            this.N = null;
            this.R = null;
        }
    }

    @Override
    public void prepare(int dim, int start, int end) {
        super.prepare(dim, start, end);
        if (this.e != null) {
            this.e.prepare(start, end);
            this.f.prepare(start, end);
            this.N.prepare(dim, start, end);
            this.R.prepare(dim, start, end);
        }
    }

    @Override
    public void rescaleVariances(double factor) {
        super.rescaleVariances(factor);
        if (this.f != null) {
            this.f.rescale(factor);
            this.N.rescale(factor);
            this.e.rescale(factor);
            this.R.rescale(factor);
        }
    }

    public static DefaultSmoothingResults full() {
        return new DefaultSmoothingResults(true, true);
    }

    public static DefaultSmoothingResults light() {
        return new DefaultSmoothingResults(false, false);
    }

    @Override
    public void saveSmoothation(int t, double err, double v) {
        if (this.e == null) {
            return;
        }
        this.e.save(t, err);
        this.f.save(t, v);
    }

    @Override
    public void saveR(int pos, DataBlock r, FastMatrix rvar) {
        if (this.N == null) {
            return;
        }
        this.R.save(pos, r);
        this.N.save(pos, rvar);
    }

    public DoubleSeq errors() {
        return this.e == null ? null : this.e.asDoublesReader(true);
    }

    public DoubleSeq errorVariances() {
        return this.f == null ? null : this.f.asDoublesReader(true);
    }

    @Override
    public DoubleSeq R(int pos) {
        if (this.R == null) {
            throw new UnsupportedOperationException();
        }
        return this.R.datablock(pos);
    }

    @Override
    public FastMatrix RVariance(int pos) {
        if (this.N == null) {
            throw new UnsupportedOperationException();
        }
        return this.N.matrix(pos);
    }

    @Override
    public double smoothation(int pos) {
        if (this.e == null) {
            throw new UnsupportedOperationException();
        }
        return this.e.get(pos);
    }

    @Override
    public DoubleSeq smoothations() {
        if (this.e == null) {
            throw new UnsupportedOperationException();
        }
        return this.e.all();
    }

    @Override
    public double smoothationVariance(int pos) {
        if (this.f == null) {
            throw new UnsupportedOperationException();
        }
        return this.f.get(pos);
    }
}

