/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.Iterator;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.IDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.impl.LitVar;
import org.chocosolver.solver.variables.impl.lazyness.ILazyBound;
import org.chocosolver.solver.variables.impl.lazyness.StrongBound;
import org.chocosolver.solver.variables.impl.lazyness.WeakBound;
import org.chocosolver.solver.variables.impl.scheduler.IntEvtScheduler;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

@Explained
public final class IntVarLazyLit
extends AbstractVariable
implements IntVar,
LitVar {
    final IntVar var;
    final MiniSat sat;
    boolean channeling = true;
    private final ILazyBound bnd;
    int valLit;
    final int min0;
    final int max0;

    public IntVarLazyLit(IntVar var) {
        super(var.getName(), var.getModel());
        this.model.unassociates(var);
        this.var = var;
        this.min0 = var.getLB();
        this.max0 = var.getUB();
        if (var.hasEnumeratedDomain()) {
            throw new UnsupportedOperationException("IntVarLazyLit can only wrap bounded integer variables");
        }
        this.sat = this.getModel().getSolver().getSat();
        this.bnd = this.getModel().getSettings().intVarLazyLitWithWeakBounds() ? new WeakBound(this.getModel()) : new StrongBound(this.getModel(), this.min0, this.max0);
        this.valLit = MiniSat.makeLiteral(this.sat.nVars(), true);
        this.sat.newVariable(new MiniSat.ChannelInfo(this, 1, 2, 0, false));
        if (var.isInstantiated()) {
            this.sat.cEnqueue(this.getLit(this.valLit, 1), Reason.undef());
        }
    }

    @Override
    public void channel(int val, int val_type, int sign) {
        block8: {
            this.channeling = false;
            int op = val_type * 3 ^ sign;
            try {
                switch (op) {
                    case 0: {
                        this.removeValue(val, Cause.Null, Reason.undef());
                        break;
                    }
                    case 1: {
                        this.instantiateTo(val, Cause.Null, Reason.undef());
                        break;
                    }
                    case 2: {
                        this.updateLowerBound(val + 1, Cause.Null, Reason.undef());
                        break;
                    }
                    case 3: {
                        this.updateUpperBound(val, Cause.Null, Reason.undef());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("IntVarLazyLit#channel : are you trying to fix valLit?");
                    }
                }
            }
            catch (ContradictionException ce) {
                if ($assertionsDisabled || this.sat.confl != MiniSat.C_Undef) break block8;
                throw new AssertionError();
            }
        }
        this.channeling = true;
    }

    @Override
    public int getLit(int val, int type) {
        if (val < this.getLB()) {
            return 1 ^ type & 1;
        }
        if (val > this.getUB()) {
            return type & 1;
        }
        switch (type) {
            case 2: {
                return this.getGELit(val);
            }
            case 3: {
                return this.getLELit(val);
            }
        }
        throw new UnsupportedOperationException("IntVarLazyLit does not support this type of literal");
    }

    @Override
    public int getMinLit() {
        return MiniSat.makeLiteral(this.bnd.currentMinVar(), false);
    }

    @Override
    public int getMaxLit() {
        return MiniSat.makeLiteral(this.bnd.currentMaxVar(), true);
    }

    @Override
    public int getValLit() {
        assert (this.isInstantiated());
        return MiniSat.neg(this.valLit);
    }

    @Override
    public int getGELit(int v) {
        if (v < this.min0) {
            return 1;
        }
        if (v > this.max0) {
            return 0;
        }
        if (v > this.getUB()) {
            return this.getMaxLit();
        }
        assert (v >= this.getLB()) : this.var + " >= " + v;
        return this.extracted(v);
    }

    private int extracted(int v) {
        int prev = this.previousValue(v);
        prev = prev == Integer.MIN_VALUE ? v - 1 : prev;
        int var = this.bnd.getSATVar(prev, this, this.sat);
        return MiniSat.makeLiteral(var, true);
    }

    @Override
    public int getLELit(int v) {
        if (v < this.min0) {
            return 0;
        }
        if (v > this.max0) {
            return 1;
        }
        if (v < this.getLB()) {
            return this.getMinLit();
        }
        return MiniSat.neg(this.getGELit(v + 1));
    }

    void channelMin(int v, int p) {
        Reason r = Reason.r(MiniSat.neg(p));
        int prev = this.previousValue(v);
        this.bnd.channelMin(prev, this.sat, r);
    }

    void channelMax(int v, int p) {
        Reason r = Reason.r(MiniSat.neg(p));
        this.bnd.channelMax(v, this.sat, r);
    }

    void updateFixed() {
        Reason r = Reason.r(this.getMinLit(), this.getMaxLit());
        this.sat.cEnqueue(this.valLit, r);
    }

    @Override
    public boolean removeValue(int value, ICause cause, Reason reason) throws ContradictionException {
        assert (cause != null);
        if (value == this.getLB()) {
            return this.updateLowerBound(value + 1, cause, Reason.gather(reason, this.getMinLit()));
        }
        if (value == this.getUB()) {
            return this.updateUpperBound(value - 1, cause, Reason.gather(reason, this.getMaxLit()));
        }
        return false;
    }

    @Override
    public boolean removeValues(IntIterableSet values, ICause cause, Reason reason) throws ContradictionException {
        throw new UnsupportedOperationException("#removeValues");
    }

    @Override
    public boolean removeAllValuesBut(IntIterableSet values, ICause cause, Reason reason) throws ContradictionException {
        throw new UnsupportedOperationException("#removeAllValuesBut");
    }

    @Override
    public boolean instantiateTo(int value, ICause cause, Reason reason) throws ContradictionException {
        return this.updateLowerBound(value, cause, reason) | this.updateUpperBound(value, cause, reason);
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause, Reason reason) throws ContradictionException {
        if (value > this.getLB()) {
            int p = this.getGELit(value);
            if (this.channeling) {
                this.notify(reason, cause, this.sat, p);
            }
            if (value > this.getUB()) {
                assert (this.sat.confl != MiniSat.C_Undef);
                this.contradiction(cause, "sat failure");
            }
            this.channelMin(value, p);
            int ub = this.getUB();
            IntEventType e = IntEventType.INCLOW;
            if (value == ub) {
                this.updateFixed();
                e = IntEventType.INSTANTIATE;
            }
            this.var.updateLowerBound(value, (ICause)Cause.Null);
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause, Reason reason) throws ContradictionException {
        if (value < this.getUB()) {
            int p = this.getLELit(value);
            if (this.channeling) {
                this.notify(reason, cause, this.sat, p);
            }
            if (value < this.getLB()) {
                assert (this.sat.confl != MiniSat.C_Undef);
                this.contradiction(cause, "sat failure");
            }
            this.channelMax(value, p);
            int lb = this.getLB();
            IntEventType e = IntEventType.DECUPP;
            if (value == lb) {
                this.updateFixed();
                e = IntEventType.INSTANTIATE;
            }
            this.var.updateUpperBound(value, (ICause)Cause.Null);
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateBounds(int lb, int ub, ICause cause, Reason reason) throws ContradictionException {
        throw new UnsupportedOperationException("#updateBounds");
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        throw new UnsupportedOperationException("#removeInterval");
    }

    @Override
    public boolean contains(int value) {
        return this.var.contains(value);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.var.isInstantiatedTo(value);
    }

    @Override
    public int getValue() throws IllegalStateException {
        return this.var.getValue();
    }

    @Override
    public int getLB() {
        return this.var.getLB();
    }

    @Override
    public int getUB() {
        return this.var.getUB();
    }

    @Override
    public int getRange() {
        return this.var.getRange();
    }

    @Override
    public int nextValue(int v) {
        return this.var.nextValue(v);
    }

    @Override
    public int nextValueOut(int v) {
        return this.var.nextValueOut(v);
    }

    @Override
    public int previousValue(int v) {
        return this.var.previousValue(v);
    }

    @Override
    public int previousValueOut(int v) {
        return this.var.previousValueOut(v);
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        return this.var.getValueIterator(bottomUp);
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        return this.var.getRangeIterator(bottomUp);
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return this.var.hasEnumeratedDomain();
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        return this.var.monitorDelta(propagator);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.var.iterator();
    }

    @Override
    public boolean isInstantiated() {
        return this.var.isInstantiated();
    }

    @Override
    public int getDomainSize() {
        return this.var.getDomainSize();
    }

    @Override
    public IDelta getDelta() {
        return this.var.getDelta();
    }

    @Override
    public void createDelta() {
        this.var.createDelta();
    }

    @Override
    public int getTypeAndKind() {
        return this.var == null ? 9 : this.var.getTypeAndKind();
    }

    protected EvtScheduler<IntEventType> createScheduler() {
        return new IntEvtScheduler();
    }

    @Override
    public String toString() {
        return this.var.toString();
    }
}

