## ----echo=FALSE,results="hide"----------------------------------------------------------
options(width=90)

## ---------------------------------------------------------------------------------------
require(nipals)
B <- matrix(c(50, 67, 90, 98, 120,
              55, 71, 93, 102, 129,
              65, 76, 95, 105, 134,
              50, 80, 102, 130, 138,
              60, 82, 97, 135, 151,
              65, 89, 106, 137, 153,
              75, 95, 117, 133, 155), ncol=5, byrow=TRUE)
B2 <- B
B2[1,1] <- B2[2,1] <- NA
m0 <- svd(scale(B)) # center and scale

## ---------------------------------------------------------------------------------------
require("nipals")
m1 <- nipals::nipals(B2, gramschmidt=FALSE)
m2 <- nipals::nipals(B2, gramschmidt=TRUE)

## ---------------------------------------------------------------------------------------
round( m1$eig, 3)
round( m2$eig, 3)

## ---------------------------------------------------------------------------------------
# loadings
round( crossprod(m1$loadings), 3) # P'P = t(P) %*% P
round( crossprod(m2$loadings), 3)

## ---------------------------------------------------------------------------------------
# scores
round( crossprod(m1$scores), 3) # T'T = t(T) %*% T
round( crossprod(m2$scores), 3)

