/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents;

import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Simulator;

public abstract class Continuous {
    boolean active;
    double value;
    Event ev;
    double phi;
    double pi;
    double buffer;
    double sum;
    private Simulator sim;

    public Continuous() {
        this.active = false;
        this.sim = Simulator.getDefaultSimulator();
    }

    public Continuous(Simulator sim) {
        if (sim == null) {
            throw new NullPointerException();
        }
        this.active = false;
        this.sim = sim;
    }

    public void init(double val) {
        this.value = val;
    }

    public double value() {
        return this.value;
    }

    public Simulator simulator() {
        return this.sim;
    }

    public void setSimulator(Simulator sim) {
        if (sim == null) {
            throw new NullPointerException();
        }
        this.sim = sim;
    }

    public void startInteg() {
        this.sim.continuousState().startInteg(this);
    }

    public void startInteg(double val) {
        this.init(val);
        this.startInteg();
    }

    public void stopInteg() {
        this.sim.continuousState().stopInteg(this);
    }

    public abstract double derivative(double var1);

    public void afterEachStep() {
    }

    public static void selectEuler(double h) {
        Simulator.getDefaultSimulator().continuousState().selectEuler(h);
    }

    public static void selectRungeKutta4(double h) {
        Simulator.getDefaultSimulator().continuousState().selectRungeKutta4(h);
    }

    public static void selectRungeKutta2(double h) {
        Simulator.getDefaultSimulator().continuousState().selectRungeKutta2(h);
    }
}

