library("rio")
x <- import("preisliste_lebensfuchs_home_blog.xlsx")
lastprod <- ''
prod  <- c()
preis <- c()
for (i in 1:nrow(x)) {
  if (!is.na(x[i,1]) && !is.na(x[i,2])) {
    lastprod <- strsplit(x[i,1], " ", fixed=TRUE)[[1]]
    lastprod <- paste(lastprod[-length(lastprod)], collapse = " ")
    preisi   <- as.numeric(x[i,2])
    if (!is.na(preisi)) {
      prod     <- c(prod, paste(x[i,1], "Eigenmarke", sep=" - "))
      preis    <- c(preis, preisi)
    }
  }
  if (!is.na(x[i,5]) && !is.na(x[i,6])) {
    preisi   <- as.numeric(x[i,6])
    if (!is.na(preisi)) {
      prod  <- c(prod,  paste(lastprod, x[i,5], sep=" - "))
      preis <- c(preis, preisi)
    }
  }
  print(c(i, length(prod), length(preis)))
}
df <- data.frame(produkt=prod, preis=preis)
export(df, "lebensfuchs.xlsx")