/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.simpleDesign;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.loggers.Loggable;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.RandomWalkOperator;
import dr.inference.operators.SimpleOperatorSchedule;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;
import dr.util.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ohdsi.likelihood.CachedModelLikelihood;
import org.ohdsi.mcmc.Analysis;
import org.ohdsi.mcmc.Runner;
import org.ohdsi.metaAnalysis.EmpiricalDataModel;
import org.ohdsi.metaAnalysis.ExtendingEmpiricalDataModel;

public class ProfileNormalAnalysis
implements Analysis {
    private final Likelihood likelihood;
    private final Likelihood prior;
    private final Likelihood joint;
    private final Parameter beta;
    private final OperatorSchedule schedule;

    public ProfileNormalAnalysis(EmpiricalDataModel profileLikelihood, double priorMean, double priorSd, double startingValue) {
        this.likelihood = new CachedModelLikelihood("likelihood", profileLikelihood);
        this.beta = profileLikelihood.getCompoundParameter();
        int i = 0;
        while (i < this.beta.getDimension()) {
            this.beta.setParameterValue(i, startingValue);
            ++i;
        }
        DistributionLikelihood betaPrior = new DistributionLikelihood((Distribution)new NormalDistribution(priorMean, priorSd));
        betaPrior.addData((Attribute)this.beta);
        this.prior = betaPrior;
        this.prior.setId("prior");
        this.joint = new CompoundLikelihood(Arrays.asList(this.likelihood, this.prior));
        this.joint.setId("joint");
        this.schedule = new SimpleOperatorSchedule(1000, 0.0);
        double defaultWeight = 1.0;
        AdaptationMode mode = AdaptationMode.ADAPTATION_ON;
        RandomWalkOperator.BoundaryCondition condition = RandomWalkOperator.BoundaryCondition.reflecting;
        for (Parameter p : profileLikelihood.getIndividualParameters()) {
            this.schedule.addOperator((MCMCOperator)new RandomWalkOperator(p, null, 0.75, condition, defaultWeight, mode));
        }
    }

    @Override
    public List<Loggable> getLoggerColumns() {
        ArrayList<Loggable> columns = new ArrayList<Loggable>();
        columns.add((Loggable)this.likelihood);
        columns.add((Loggable)this.prior);
        columns.add((Loggable)this.beta);
        return columns;
    }

    @Override
    public Likelihood getJoint() {
        return this.joint;
    }

    @Override
    public OperatorSchedule getSchedule() {
        return this.schedule;
    }

    public static void main(String[] args) {
        int chainLength = 1100000;
        int burnIn = 100000;
        int subSampleFrequency = 1000;
        ExtendingEmpiricalDataModel dataModel = new ExtendingEmpiricalDataModel("profile.txt");
        ProfileNormalAnalysis analysis = new ProfileNormalAnalysis(dataModel, 0.0, 10.0, 0.0);
        Runner runner = new Runner(analysis, chainLength, burnIn, subSampleFrequency, 666.0);
        runner.run();
        runner.processSamples();
    }
}

